<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getListByParams(array $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建购物车
     *
     * @support  array $products 购物车产品集合 [ require true ]
     * @support  int $userId 用户id 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改购物车
     *
     * @support  array $products 购物车产品集合 [ require true ]
     * @support  int $userId 用户id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除购物车
     *
     * @support  array $ids 缓存ids [ require true ]
     * @support  int $userId 用户id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 展示购物车
     *
     * @support  int $userId 用户id 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}