<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserCouponsByParams(array $params)
 * @method getSkuEffectiveCouponsByParams(array $params)
 * @method getCouponsListByParams(array $params)
 * @method calculatePriceByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户优惠券
     *
     * @support  array $status 优惠券状态;已激活【已激活可能还未绑定】:activated;未使用:unused;使用:used;已作废:abolished;已过期:expired; 
     * @support  string $applyIn 应用于业务 
     * @support  bool $withTemplateInfo 获取模板信息 
     * @throws  \Exception
     * @return  array
     */
    public static function getUserCoupons () {
        return self::getClass()->getUserCoupons();
    }

    /**
     * 获取Sku有效优惠券
     *
     * @support  array $products 订单故障信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuEffectiveCoupons () {
        return self::getClass()->getSkuEffectiveCoupons();
    }

    /**
     * 获取领取优惠券列表
     *
     * @support  array $ids 优惠券ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponsList () {
        return self::getClass()->getCouponsList();
    }

    /**
     * 计算优惠金额
     *
     * @param  float $sellPrice 预计价格 [Original type double] [ require true ]
     * @param  float $canPrice 订单sku快照价格 [Original type double] [ require true ]
     * @param  array $info 优惠券信息 [ require true ]
     * @throws  \Exception
     * @return  float
     */
    public static function calculatePrice (float $sellPrice, float $canPrice, array $info) {
        return self::getClass()->calculatePrice([
            "sellPrice" => $sellPrice,
            "canPrice" => $canPrice,
            "info" => $info,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}