<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setPayMaxRefundFailedByParams(array $params)
 * @method setPayMaxRefundSuccessByParams(array $params)
 * @method setPayMaxRefundResultDoubtfulByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置拉卡拉退款异常存疑结果为拉卡拉未退款
     *
     * @param  int $refundId 退款单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPayMaxRefundFailed (int $refundId) {
        return self::getClass()->setPayMaxRefundFailed([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 设置拉卡拉退款异常存疑结果为拉卡拉已经退款
     *
     * @param  int $refundId 退款单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPayMaxRefundSuccess (int $refundId) {
        return self::getClass()->setPayMaxRefundSuccess([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 重新设置拉卡拉退款异常存疑结果存疑
     *
     * @param  int $refundId 退款单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPayMaxRefundResultDoubtful (int $refundId) {
        return self::getClass()->setPayMaxRefundResultDoubtful([
            "refundId" => $refundId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}