<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreGroupByProductIdByParams(array $params)
 * @method clearStoreGroupByProductIdByParams(array $params)
 * @method deleteStoreGroupByProductIdByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取商品门店组信息
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreGroupByProductId (int $id) {
        return self::getClass()->getStoreGroupByProductId([
            "id" => $id,
        ]);
    }

    /**
     * 清空商品与门店、门店组关系
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearStoreGroupByProductId (int $id) {
        return self::getClass()->clearStoreGroupByProductId([
            "id" => $id,
        ]);
    }

    /**
     * 删除商品与门店的关系
     *
     * @param  int $id 产品id [ require true ]
     * @param  array $storeIds 门店id列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStoreGroupByProductId (int $id, array $storeIds) {
        return self::getClass()->deleteStoreGroupByProductId([
            "id" => $id,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}