<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Notice;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method noticeCategoryListBySourceByParams(array $params)
 * @method noticeHomePageListByParams(array $params)
 * @method noticeListByParams(array $params)
 * @method noticeDetailByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Notice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建公告
     *
     * @support  int $noticeCategoryId 板块id [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 正文 [ require true ]
     * @support  array $noticeAnnex 附件信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑公告
     *
     * @support  int $id 公告id [ require true ]
     * @support  int $noticeCategoryId 板块id [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 正文 [ require true ]
     * @support  array $noticeAnnex 附件信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取公告板块列表名称
     *
     * @param  int $source 分类类型1普通公告 2 榜单 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function noticeCategoryListBySource (int $source) {
        return self::getClass()->noticeCategoryListBySource([
            "source" => $source,
        ]);
    }

    /**
     * 公告首页列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function noticeHomePageList () {
        return self::getClass()->noticeHomePageList();
    }

    /**
     * 公告列表
     *
     * @support  int $noticeCategoryId 分类类型1普通公告 2榜单 [ require true ]
     * @support  string $title 标题 
     * @support  string $publishAtBegin 发布时间开始 
     * @support  string $publishAtEnd 发布时间结束 
     * @support  int $page 页数 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function noticeList () {
        return self::getClass()->noticeList();
    }

    /**
     * 公告详情
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function noticeDetail (int $id) {
        return self::getClass()->noticeDetail([
            "id" => $id,
        ]);
    }

    /**
     * 删除公告
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Notice\Notice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Notice\Notice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}