<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Project;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method productImportByParams(array $params)
 * @method terminateByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkuListByParams(array $params)
 */
class Project {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增收集计划
     *
     * @support  string $name 计划名称 [ require true ]
     * @support  string $project_start 开始时间 [ require true ]
     * @support  string $project_end 结束时间 [ require true ]
     * @support  string $description 计划说明 [ require true ]
     * @support  array $sku_info 关联sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 计划列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $page 当前页 [Original type uint] 
     * @support  int $pageSize 页内条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 返回导入的SKU信息
     *
     * @param  array $info 商品信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productImport (array $info) {
        return self::getClass()->productImport([
            "info" => $info,
        ]);
    }

    /**
     * 计划终止
     *
     * @param  int $id 计划ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function terminate (int $id) {
        return self::getClass()->terminate([
            "id" => $id,
        ]);
    }

    /**
     * 计划详情
     *
     * @param  int $id 计划ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 计划包含的SKU
     *
     * @support  int $project_id 计划ID [Original type uint] [ require true ]
     * @support  string $skuName SKU名称(模糊查询) 
     * @support  int $categoryId 类目ID 
     * @support  int $page 当前页 [Original type uint] 
     * @support  int $pageSize 页内条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuList () {
        return self::getClass()->getSkuList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Project\Project');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Project\Project');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}