<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Project;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStateByParams(array $params)
 * @method saveByParams(array $params)
 */
class ProjectStore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店收集状态
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getState () {
        return self::getClass()->getState();
    }

    /**
     * 门店填写收集
     *
     * @param  int $project_id 计划ID [Original type uint] [ require true ]
     * @param  array $sku_info 关联sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function save (int $project_id, array $sku_info) {
        return self::getClass()->save([
            "project_id" => $project_id,
            "sku_info" => $sku_info,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Project\ProjectStore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Project\ProjectStore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}