<?php
namespace Mainto\Bridge\Invokes\ProjectProcess\Process;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createProcessByParams(array|\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateProcessCmd $params)
 * @method createConfigByParams(array|\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateConfigCmd $params)
 * @method createStatusByParams(array|\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateStatusCmd $params)
 * @method createFieldByParams(array|\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateFieldCmd $params)
 * @method fieldsByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createProcess
     *
     * @var  \Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateProcessCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessDTO
     */
    public static function createProcess (\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateProcessCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createProcess($cmd),
            "\Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessDTO"
        );
    }


    /**
     * createConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateConfigCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessConfigDTO
     */
    public static function createConfig (\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateConfigCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createConfig($cmd),
            "\Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessConfigDTO"
        );
    }


    /**
     * createStatus
     *
     * @var  \Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateStatusCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessStatusDTO
     */
    public static function createStatus (\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateStatusCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createStatus($cmd),
            "\Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessStatusDTO"
        );
    }


    /**
     * createField
     *
     * @var  \Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateFieldCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessFieldDTO
     */
    public static function createField (\Mainto\Bridge\Structs\ProjectProcess\Process\Cmd\CreateFieldCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createField($cmd),
            "\Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessFieldDTO"
        );
    }


    /**
     * fields
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectProcess\Process\DTO\ProcessFieldDTO[]
     */
    public static function fields () {
        return self::getClass()->fields();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectProcess', 'Process\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectProcess', 'Process\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}