<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-12 20:09:57
 */
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Operator;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectPictureOnline";

    private static string $className = "Admin\\Operator\\Product";

    /**
     * 添加产品类别
     * @return  bool
    */
    public static function addProductCategory (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductCategory(["name" => $name]);
    }
    /**
     * 添加看片产品
     * @return  bool
    */
    public static function addProduct (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Operator\AddProduct $addProduct) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProduct($addProduct);
    }
    /**
     * 获取在线看片产品类别列表
     * @return  array
    */
    public static function getProductCategoryList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryList();
    }
    /**
     * 获取在线看片产品详情
     * @return  array
    */
    public static function getProductDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDetail(["id" => $id]);
    }
    /**
     * 获取在线看片产品列表
     * @return  array
    */
    public static function getProductList (array $productIds = [], array $modules = [], array $categoryIds = [], int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["productIds" => $productIds, "modules" => $modules, "categoryIds" => $categoryIds, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取不在在线看片产品列表
     * @return  array
    */
    public static function getNotOnlineProductList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNotOnlineProductList();
    }
    /**
     * 获取所有在线看片产品
     * @return  array
    */
    public static function getAllOnlineProduct (bool $onlyEnable = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllOnlineProduct(["onlyEnable" => $onlyEnable]);
    }
    /**
     * 编辑在线看片产品
     * @return  bool
    */
    public static function editOnlineProduct (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Operator\EditProduct $editProduct) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editOnlineProduct($editProduct);
    }
    /**
     * 开启在线看片产品
     * @return  bool
    */
    public static function enableOnlineProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableOnlineProduct(["id" => $id]);
    }
    /**
     * 禁用在线看片产品
     * @return  bool
    */
    public static function disableOnlineProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableOnlineProduct(["id" => $id]);
    }
    /**
     * 获取在线看片产品详情 通过外部产品ID
     * @return  array
    */
    public static function getProductDetailByOutProductId (int $out_product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDetailByOutProductId(["out_product_id" => $out_product_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}