<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-24 18:06:26
 */
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Common
 */
class Common {
    private static string $serviceName = "ProjectPictureOnline";

    private static string $className = "Common";

    /**
     * 获取七牛云上传token
     * @return  string
    */
    public static function getUploadToken (string $dirRule = 'default') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUploadToken(["dirRule" => $dirRule]);
    }
    /**
     * 获取又拍云签名
     * @return  mixed
    */
    public static function getUpyunSign () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpyunSign();
    }
    /**
     * 获取host
     * @return  mixed
    */
    public static function getHost () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHost();
    }
    /**
     * 获取hostInitPrefix
     * @return  mixed
    */
    public static function getHostInitPrefix () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHostInitPrefix();
    }
    /**
     * 获取机构
     * @return  mixed
    */
    public static function getOrgInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrgInfo();
    }
    /**
     * 事件记录
     * @return  mixed
    */
    public static function eventLog (int $eventId, array $data = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->eventLog(["eventId" => $eventId, "data" => $data]);
    }
    /**
     * 获取反馈标签s
     * @return  mixed
    */
    public static function getFeedbackLabels () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFeedbackLabels();
    }
    /**
     * 获取im票据
     * @return  mixed
    */
    public static function getImSign (int $id, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImSign(["id" => $id, "type" => $type]);
    }
    /**
     * 根据code绑定用户
     * @return  mixed
    */
    public static function bindUserWechatByCode (int $userId, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserWechatByCode(["userId" => $userId, "code" => $code]);
    }
    /**
     * 获取贴图
     * @return  mixed
    */
    public static function getMappingPic (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMappingPic(["productId" => $productId]);
    }
    /**
     * 根据根节点id获取产品分类树
     * @return  array
    */
    public static function getProductCategoryTree (int $rootId, bool $withProduct = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryTree(["rootId" => $rootId, "withProduct" => $withProduct]);
    }
    /**
     * 获取裁剪用途
     * @return  array
    */
    public static function getPhotoSizeUse () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeUse();
    }
    /**
     * 获取国家列表
     * @return  array
    */
    public static function getCountryList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCountryList();
    }
    /**
     * 看片师列表
     * @return  mixed
    */
    public static function getWatcherList (\Mainto\Bridge\Structs\ProjectPictureOnline\Common\GetWatcherListParamsConds $conds = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWatcherList(["conds" => $conds]);
    }
    /**
     * 获取聊天记录
     * @return  mixed
    */
    public static function getGroupImHistory (string $conversationID, int $count = 15, int $nextReqMessageID = -1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupImHistory(["conversationID" => $conversationID, "count" => $count, "nextReqMessageID" => $nextReqMessageID]);
    }
    /**
     * 获取区域信息
     * @return  mixed
    */
    public static function getAreaTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaTree();
    }
    /**
     * 根据看片单id获取历史修图师 - 去重
     * @return  array
    */
    public static function getWatchRecordHistoryWatcher (int $watchRecordId, string $type = 'user') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWatchRecordHistoryWatcher(["watchRecordId" => $watchRecordId, "type" => $type]);
    }
    /**
     * 看片单是否可继续聊天
     * @return  \Mainto\Bridge\Structs\ProjectPictureOnline\DTO\CanChatByWatchRecordDTO
    */
    public static function canChatByWatchRecord (string $watchRecordNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->canChatByWatchRecord(["watchRecordNo" => $watchRecordNo]),
            "\Mainto\Bridge\Structs\ProjectPictureOnline\DTO\CanChatByWatchRecordDTO"
        );
    }
    /**
     * 创建聊天群组
     * @return  mixed
    */
    public static function createImGroup (string $watchRecordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createImGroup(["watchRecordNo" => $watchRecordNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}