<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-18 11:28:51
 */
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WatchRecord
 */
class WatchRecord {
    private static string $serviceName = "ProjectPictureOnline";

    private static string $className = "SmallProgram\\My\\WatchRecord";

    /**
     * 检查是否为第一次看片
     * @return  bool
    */
    public static function checkFirstWatch (int $watchRecordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkFirstWatch(["watchRecordId" => $watchRecordId]);
    }
    /**
     * 根据看片[序列号/id]获取看片单信息
     * @return  array
    */
    public static function detail (int $id, string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "recordNo" => $recordNo]);
    }
    /**
     * 保存看片方式
     * @return  mixed
    */
    public static function saveWatchType (int $id, string $watchType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveWatchType(["id" => $id, "watchType" => $watchType]);
    }
    /**
     * 根据手机号＋验证码或者微信登录, 获取看片单列表
     * @return  array
    */
    public static function getWatchRecordsByPhoneWithCode (string $outsideNo = null, int $page = 1, int $pageSize = 10, string $phone, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWatchRecordsByPhoneWithCode(["outsideNo" => $outsideNo, "page" => $page, "pageSize" => $pageSize, "phone" => $phone, "code" => $code]);
    }
    /**
     * 保存取片方式
     * @return  mixed
    */
    public static function saveTakeType (int $id, string $takeType, string $takeRemark = '', \Mainto\Bridge\Structs\ProjectPictureOnline\SmallProgram\My\WatchRecord\SaveTakeTypeParamsPostInfo $postInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveTakeType(["id" => $id, "takeType" => $takeType, "takeRemark" => $takeRemark, "postInfo" => $postInfo]);
    }
    /**
     * 获取取片方式
     * @return  array
    */
    public static function getTakeType (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTakeType(["id" => $id]);
    }
    /**
     * 看片单禁止自动回复(不再提示)
     * @return  mixed
    */
    public static function banReply (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->banReply(["id" => $id]);
    }
    /**
     * 看片单自动回复
     * @return  mixed
    */
    public static function reply (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reply(["id" => $id]);
    }
    /**
     * 获取看片单对应看片师工作状态
     * @return  mixed
    */
    public static function getRecordWatcherWorkState (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRecordWatcherWorkState(["id" => $id]);
    }
    /**
     * 获取看片单对应队列位置
     * @return  mixed
    */
    public static function getRecordPosition (int $id, bool $withMessage = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRecordPosition(["id" => $id, "withMessage" => $withMessage]);
    }
    /**
     * 触发小助手消息--是否需要修图师帮助
     * @return  bool
    */
    public static function needEnterQueue (int $watchRecordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->needEnterQueue(["watchRecordId" => $watchRecordId]);
    }
    /**
     * 顾客点击按钮进入队列
     * @return  mixed
    */
    public static function enterQueue (int $watchRecordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enterQueue(["watchRecordId" => $watchRecordId]);
    }
    /**
     * 看片单最终满意[删除模板照]
     * @return  bool
    */
    public static function satisfied (string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->satisfied(["recordNo" => $recordNo]);
    }
    /**
     * 看片单是否可最终完成
     * @return  bool
    */
    public static function checkWatchRecordCanSatisfied (string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWatchRecordCanSatisfied(["recordNo" => $recordNo]);
    }
    /**
     * 是否有试点门店订单 - 当前用户小程序端展示取片柜icon
     * @return  bool
    */
    public static function haveExperimentOrder (string $phone, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveExperimentOrder(["phone" => $phone, "code" => $code]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}