<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 14:08:57
 */
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Photo
 */
class Photo {
    private static string $serviceName = "ProjectPictureOnline";

    private static string $className = "SmallProgram\\My\\Photo";

    /**
     * 根据看片单获取照片信息
     * @return  array
    */
    public static function getPhotosByRecordId (int $recordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotosByRecordId(["recordId" => $recordId]);
    }
    /**
     * 保存反馈信息
     * @return  bool
    */
    public static function saveFeedbackRecord (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\SaveFeedbackPhoto $saveFeedbackPhoto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveFeedbackRecord($saveFeedbackPhoto);
    }
    /**
     * 创建反馈
     * @return  bool
    */
    public static function feedback (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\FeedbackPhoto $feedbackPhoto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->feedback($feedbackPhoto);
    }
    /**
     * 批量反馈
     * @return  bool
    */
    public static function batchFeedback (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchFeedbackCmd $batchFeedbackCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchFeedback($batchFeedbackCmd);
    }
    /**
     * 照片满意
     * @return  bool
    */
    public static function satisfied (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->satisfied(["id" => $id]);
    }
    /**
     * 照片满意
     * @return  bool
    */
    public static function batchSatisfied (array $ids, int $watchRecordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSatisfied(["ids" => $ids, "watchRecordId" => $watchRecordId]);
    }
    /**
     * 提交其他处理信息
     * @return  bool
    */
    public static function submitOtherInfo (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchOtherInfoCmd $batchOtherInfoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitOtherInfo($batchOtherInfoCmd);
    }
    /**
     * 图像算法排版
     * @return  mixed
    */
    public static function cropFormat (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Photo\FormatCmd $formatCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cropFormat($formatCmd);
    }
    /**
     * 标记照片已读 - v4.4
     * @return  bool
    */
    public static function readPhoto (int $photoId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->readPhoto(["photoId" => $photoId]);
    }
    /**
     * 获取未读照片数量 - v4.4
     * @return  int
    */
    public static function getUnReadUpdatePhoto (string $phone, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnReadUpdatePhoto(["phone" => $phone, "code" => $code]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}