<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 14:23:27
 */
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Operator;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 */
class Store {
    private static string $serviceName = "ProjectPictureOnline";

    private static string $className = "Admin\\Operator\\Store";

    /**
     * 添加在线看片门店
     * @return  bool
    */
    public static function addOnlineStore (int $outStoreId, string $module, bool $onlySelfTake, array $productIds = [], array $takeProductCategories = [], array $takeStaffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOnlineStore(["outStoreId" => $outStoreId, "module" => $module, "onlySelfTake" => $onlySelfTake, "productIds" => $productIds, "takeProductCategories" => $takeProductCategories, "takeStaffIds" => $takeStaffIds]);
    }
    /**
     * 编辑在线看片门店
     * @return  bool
    */
    public static function editOnlineStore (int $id, string $module, bool $onlySelfTake, array $productIds = [], array $takeProductCategories = [], array $takeStaffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editOnlineStore(["id" => $id, "module" => $module, "onlySelfTake" => $onlySelfTake, "productIds" => $productIds, "takeProductCategories" => $takeProductCategories, "takeStaffIds" => $takeStaffIds]);
    }
    /**
     * 在线看片门店列表
     * @return  array
    */
    public static function getOnlineStoreList (array $ids = [], int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOnlineStoreList(["ids" => $ids, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取不在在线看片门店列表
     * @return  array
    */
    public static function getNotOnlineStoreList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNotOnlineStoreList();
    }
    /**
     * 获取所有在线看片门店列表
     * @return  array
    */
    public static function getAllOnlineStore (bool $onlyEnable = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllOnlineStore(["onlyEnable" => $onlyEnable]);
    }
    /**
     * 获取在线看片门店信息
     * @return  array
    */
    public static function getOnlineStoreDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOnlineStoreDetail(["id" => $id]);
    }
    /**
     * 开启在线看片门店
     * @return  bool
    */
    public static function enableOnlineStore (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableOnlineStore(["id" => $id]);
    }
    /**
     * 禁用在线看片门店
     * @return  bool
    */
    public static function disableOnlineStore (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableOnlineStore(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}