<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-09 13:48:32
 */
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PhotoSize
 */
class PhotoSize {
    private static string $serviceName = "ProjectPictureOnline";

    private static string $className = "Api\\PhotoSize";

    /**
     * 根据id获取打印尺寸
     * @return  array
    */
    public static function getPhotoSizeByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeByIds(["ids" => $ids]);
    }
    /**
     * 根据产品ids获取打印尺寸类型id
     * @return  array
    */
    public static function getPhotoSizeTypeIdsByProductIds (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeTypeIdsByProductIds(["productIds" => $productIds]);
    }
    /**
     * 外部获取产品对应尺寸列表
     * @return  array
    */
    public static function getPhotoSizeList (int $productId, array $areaIds, string $areaType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeList(["productId" => $productId, "areaIds" => $areaIds, "areaType" => $areaType]);
    }
    /**
     * 根据产品ids获取产品对应尺寸列表
     * @return  array
    */
    public static function getPhotoSizeListByProductIds (array $productIds, array $areaIds, string $areaType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeListByProductIds(["productIds" => $productIds, "areaIds" => $areaIds, "areaType" => $areaType]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}