<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-23 11:53:12
 */
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WatchRecord
 */
class WatchRecord {
    private static string $serviceName = "ProjectPictureOnline";

    private static string $className = "Api\\WatchRecord";

    /**
     * 为外部订单新增看片单
     * @return  array
    */
    public static function addRecordToOrder (string $outsideNo, int $orgId, array $photos, \Mainto\Bridge\Structs\ProjectPictureOnline\Api\WatchRecord\AddRecordToOrderParamsExtends $extends = null, bool $needConfirm = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRecordToOrder(["outsideNo" => $outsideNo, "orgId" => $orgId, "photos" => $photos, "extends" => $extends, "needConfirm" => $needConfirm]);
    }
    /**
     * 修改取片信息
     * @return  mixed
    */
    public static function changePostInfo (string $recordNo, \Mainto\Bridge\Structs\ProjectPictureOnline\Api\WatchRecord\ChangePostInfoParamsPostInfo $postInfo = null, string $takeType = null, string $takeRemark = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePostInfo(["recordNo" => $recordNo, "postInfo" => $postInfo, "takeType" => $takeType, "takeRemark" => $takeRemark]);
    }
    /**
     * 关闭看片单
     * @return  mixed
    */
    public static function close (string $recordNo, string $message = '看片单已被关闭') {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["recordNo" => $recordNo, "message" => $message]);
    }
    /**
     * 删除看片单
     * @return  mixed
    */
    public static function delete (string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["recordNo" => $recordNo]);
    }
    /**
     * 删除看片单数组
     * @return  bool
    */
    public static function deleteRecordPhotos (string $recordNo, array $photoIds, string $type = 'photographer_reload') {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteRecordPhotos(["recordNo" => $recordNo, "photoIds" => $photoIds, "type" => $type]);
    }
    /**
     * 获取伙伴看片信息【1min缓存】
     * @return  mixed
    */
    public static function getStaffOnlineInfo (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffOnlineInfo(["staffId" => $staffId]);
    }
    /**
     * 是否可以裁剪、贴图、宫格
     * @return  array
    */
    public static function canChooseCropOrMappingOrSquare (string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canChooseCropOrMappingOrSquare(["recordNo" => $recordNo]);
    }
    /**
     * 标记取片
     * @return  bool
    */
    public static function hasTaken (int $id, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasTaken(["id" => $id, "operator" => $operator]);
    }
    /**
     * 获取搜索数量
     * @return  array
    */
    public static function getSearchCount (int $outStoreId, array $outsideNos = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSearchCount(["outStoreId" => $outStoreId, "outsideNos" => $outsideNos]);
    }
    /**
     * 获取看片单列表-分页
     * @return  array
    */
    public static function getWatchRecordList (int $outStoreId, array $outsideNos = [], array $userIds = [], string $takeType = '', string $takeState = '', int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWatchRecordList(["outStoreId" => $outStoreId, "outsideNos" => $outsideNos, "userIds" => $userIds, "takeType" => $takeType, "takeState" => $takeState, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 根据取片方式和取片状态获取数据
     * @return  array
    */
    public static function getByTakeTypeAndTakeState (string $takeType = '', string $takeState = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByTakeTypeAndTakeState(["takeType" => $takeType, "takeState" => $takeState]);
    }
    /**
     * 获取看片单详情
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 批量下载
     * @return  array
    */
    public static function getPhotosByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotosByIds(["ids" => $ids]);
    }
    /**
     * 二次看片
     * @return  bool
    */
    public static function recoveryRecord (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\WatchRecord\RecoveryRecord $recoveryRecord) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoveryRecord($recoveryRecord);
    }
    /**
     * 取消二次看片
     * @return  bool
    */
    public static function cancelRecoveryRecord (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\WatchRecord\CancelRecoveryRecord $cancelRecoveryRecord) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelRecoveryRecord($cancelRecoveryRecord);
    }
    /**
     * 看片师是否可接看片单列表内的订单
     * @return  array
    */
    public static function canTakeRecordListByWatcherId (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\WatchRecord\CanTakeRecordListByWatcherId $canTakeRecordListByWatcherId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->canTakeRecordListByWatcherId($canTakeRecordListByWatcherId),
            "\Mainto\Bridge\Structs\ProjectPictureOnline\DTO\WatchRecord\CanTakeRecordListDTO[]"
        );
    }
    /**
     * 在线看片订单列表-门店
     * @return  \Mainto\Bridge\Structs\ProjectPictureOnline\DTO\WatchRecord\OrderListForStoreDTO
    */
    public static function getOrderListForStore (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\WatchRecord\OrderListForStore $orderListForStore) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderListForStore($orderListForStore),
            "\Mainto\Bridge\Structs\ProjectPictureOnline\DTO\WatchRecord\OrderListForStoreDTO"
        );
    }
    /**
     * 在线看片订单详情-门店
     * @return  \Mainto\Bridge\Structs\ProjectPictureOnline\DTO\WatchRecord\OrderDetailForStoreDTO
    */
    public static function getOrderDetailForStore (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\WatchRecord\OrderDetailForStore $orderDetailForStore) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderDetailForStore($orderDetailForStore),
            "\Mainto\Bridge\Structs\ProjectPictureOnline\DTO\WatchRecord\OrderDetailForStoreDTO"
        );
    }
    /**
     * 操作看片单-接单/指派
     * @return  bool
    */
    public static function operateWatchRecord (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\WatchRecord\AssignOtherWatcherForStore $assignOtherWatcherForStore) {
        return RpcClass::getClass(self::$serviceName, self::$className)->operateWatchRecord($assignOtherWatcherForStore);
    }
    /**
     * 根据看片单号获取看片单相关状态信息-门店
     * @return  \Mainto\Bridge\Structs\ProjectPictureOnline\DTO\WatchRecord\OrderRecordsForStoreDTO
    */
    public static function getOrderRecordByRecordNosForStore (?\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\WatchRecord\OrderRecordsForStore $orderRecordsForStore = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderRecordByRecordNosForStore($orderRecordsForStore),
            "\Mainto\Bridge\Structs\ProjectPictureOnline\DTO\WatchRecord\OrderRecordsForStoreDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}