<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateUserStartWaitAtByParams(array $params)
 * @method updateUserRecordLastAtByParams(array $params)
 * @method getCanDingInfoByParams(array $params)
 * @method dingStaffByParams(array $params)
 * @method changeWatcherByParams(array $params)
 * @method canOpenNewYearMsgByParams(array $params)
 */
class Notice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新顾客开始等待时间点
     *
     * @param  int $id 看片记录id [ require true ]
     * @param  bool $forceUpdate 是否强制更新等待开始时间【忽略已存在】 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUserStartWaitAt (int $id, bool $forceUpdate = false) {
        return self::getClass()->updateUserStartWaitAt([
            "id" => $id,
            "forceUpdate" => $forceUpdate,
        ]);
    }

    /**
     * 更新顾客im反馈时间
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUserRecordLastAt (int $id) {
        return self::getClass()->updateUserRecordLastAt([
            "id" => $id,
        ]);
    }

    /**
     * 获取可钉状态
     *
     * @param  int $id 看片单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanDingInfo (int $id) {
        return self::getClass()->getCanDingInfo([
            "id" => $id,
        ]);
    }

    /**
     * ding看片师
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingStaff (int $id) {
        return self::getClass()->dingStaff([
            "id" => $id,
        ]);
    }

    /**
     * 更改看片师
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeWatcher (int $id) {
        return self::getClass()->changeWatcher([
            "id" => $id,
        ]);
    }

    /**
     * 是否需要弹窗 - 2023新年弹窗
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function canOpenNewYearMsg () {
        return self::getClass()->canOpenNewYearMsg();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'SmallProgram\My\Notice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'SmallProgram\My\Notice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}