<?php
namespace Mainto\Bridge\Enums\ProjectPictureOnline\Watch\WatchRecord;

class WatchRecordStateEnum {
    /**
     * 待反馈
     */
    const WAIT_FEEDBACK = 'wait_feedback';
    /**
     * 待接单
     */
    const UNPROCESSED = 'unprocessed';
    /**
     * 处理中
     */
    const PROCESSING = 'processing';
    /**
     * 已完成
     */
    const FINISHED = 'finished';
    /**
     * 已关闭
     */
    const CLOSED = 'closed';
    const MAP = [0 => 'wait_feedback',1 => 'unprocessed',2 => 'processing',3 => 'finished',4 => 'closed'];
    /**
     * 结束不可操作状态
     */
    const END_STATE_MAP = [0 => 'finished',1 => 'closed'];
    /**
     * 状态中文描述
     */
    const CHINESE_NAME = ['wait_feedback' => '待反馈','unprocessed' => '待接单','processing' => '处理中','finished' => '已完成','closed' => '已关闭'];
}