<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method processingWatchingRecordListByParams(array $params)
 * @method detailByParams(array $params)
 * @method takeWatchingRecordByParams(array $params)
 * @method getAcceptableWatchingRecordCountByParams(array $params)
 * @method completeWatchingRecordByParams(array $params)
 * @method getHistoryWatchingRecordListByParams(array $params)
 * @method getChangeWatchingRecordListByParams(array $params)
 * @method addAutoSendNumsByParams(array $params)
 * @method sendNoticeToUserByParams(array $params)
 * @method setPrintNumByParams(array $params)
 */
class WatchRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取处理中看片单列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function processingWatchingRecordList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->processingWatchingRecordList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取看片单详情-v2.0.0
     *
     * @param  int $id 看片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 接单-v2.0.0
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeWatchingRecord () {
        return self::getClass()->takeWatchingRecord();
    }

    /**
     * 获取可接订单数量-v2.0.0
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAcceptableWatchingRecordCount () {
        return self::getClass()->getAcceptableWatchingRecordCount();
    }

    /**
     * 看片师完成订单-v2.0.0
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeWatchingRecord (int $id) {
        return self::getClass()->completeWatchingRecord([
            "id" => $id,
        ]);
    }

    /**
     * 在线看片历史单列表-v2.0.0
     *
     * @support  string $completeStartTime 看片完成开始时间 [ require false ]
     * @support  string $completeEndTime 看片完成结束时间 [ require false ]
     * @support  string $customerName 顾客姓名 [ require false ]
     * @support  string $customerPhone 顾客手机号 [ require false ]
     * @support  string $outerOrderNum 订单号 [ require false ]
     * @support  array $states 状态 [ require false ]
     * @support  int $from 来源 [ require false ]
     * @support  bool $toOffline 是否转门店 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryWatchingRecordList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getHistoryWatchingRecordList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 在线看片更改单列表-v2.0.0
     *
     * @support  string $completeStartTime 看片完成开始时间 [ require false ]
     * @support  string $completeEndTime 看片完成结束时间 [ require false ]
     * @support  string $customerName 顾客姓名 [ require false ]
     * @support  string $customerPhone 顾客手机号 [ require false ]
     * @support  string $outerOrderNum 订单号 [ require false ]
     * @support  array $states 状态 [ require false ]
     * @support  int $from 来源 [ require false ]
     * @support  bool $toOffline 是否转门店 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChangeWatchingRecordList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getChangeWatchingRecordList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 增加自动发送次数-v2.0.0
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAutoSendNums (int $id) {
        return self::getClass()->addAutoSendNums([
            "id" => $id,
        ]);
    }

    /**
     * 发送照片更新通知
     *
     * @param  int $watchRecordId 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNoticeToUser (int $watchRecordId) {
        return self::getClass()->sendNoticeToUser([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * 设置打印张数
     *
     * @param  int $watchRecordId 看片id [ require true ]
     * @param  int $printNum 打印张数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setPrintNum (int $watchRecordId, int $printNum) {
        return self::getClass()->setPrintNum([
            "watchRecordId" => $watchRecordId,
            "printNum" => $printNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\WatchRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\WatchRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}