<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method offlineWatchRecordFinishByParams(array $params)
 * @method offlineWatchRecordBindByParams(array $params)
 * @method completeShowPicOrderByParams(array $params)
 * @method delayFinishWatchRecordByParams(array $params)
 * @method delayFinishWatchRecordNoticeByParams(array $params)
 * @method changeBindUserIdByParams(array $params)
 * @method delayClearWatchRecordGroupByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片单线下看片完成 - 自动完成
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $finishAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offlineWatchRecordFinish (string $recordNo, string $finishAt) {
        return self::getClass()->offlineWatchRecordFinish([
            "recordNo" => $recordNo,
            "finishAt" => $finishAt,
        ]);
    }

    /**
     * 看片单在线下接单
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $bindAt  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offlineWatchRecordBind (string $recordNo, string $bindAt) {
        return self::getClass()->offlineWatchRecordBind([
            "recordNo" => $recordNo,
            "bindAt" => $bindAt,
        ]);
    }

    /**
     * 监听修修兽完成订单
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  array $final_photos 完成照片数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeShowPicOrder (string $order_num, array $final_photos) {
        return self::getClass()->completeShowPicOrder([
            "order_num" => $order_num,
            "final_photos" => $final_photos,
        ]);
    }

    /**
     * 照片已经全部确认，裁剪完的看片单4h自动完成
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delayFinishWatchRecord (string $recordNo) {
        return self::getClass()->delayFinishWatchRecord([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 照片已经全部确认，裁剪完的看片单3h提醒
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delayFinishWatchRecordNotice (string $recordNo) {
        return self::getClass()->delayFinishWatchRecordNotice([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 换绑用户手机号
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeBindUserId (int $orderId, int $userId) {
        return self::getClass()->changeBindUserId([
            "orderId" => $orderId,
            "userId" => $userId,
        ]);
    }

    /**
     * 延迟关闭看片单聊天组
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $type 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delayClearWatchRecordGroup (string $orderNo, string $type) {
        return self::getClass()->delayClearWatchRecordGroup([
            "orderNo" => $orderNo,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}