<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getNicknameInfoByParams(array $params)
 * @method randomNicknameByParams(array $params)
 * @method addByParams(array $params)
 */
class StaffNickname {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取随机花名信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getNicknameInfo () {
        return self::getClass()->getNicknameInfo();
    }

    /**
     * 随机花名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function randomNickname () {
        return self::getClass()->randomNickname();
    }

    /**
     * 确认花名
     *
     * @param  string $selfNickname 花名 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function add (string $selfNickname) {
        return self::getClass()->add([
            "selfNickname" => $selfNickname,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Staff\StaffNickname');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Staff\StaffNickname');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}