<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUploadTokenByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getHostInitPrefixByParams(array $params)
 * @method getOrgInfoByParams(array $params)
 * @method eventLogByParams(array $params)
 * @method getFeedbackLabelsByParams(array $params)
 * @method getImSignByParams(array $params)
 * @method bindUserWechatByCodeByParams(array $params)
 * @method getMappingPicByParams(array $params)
 * @method getProductCategoryTreeByParams(array $params)
 * @method getPhotoSizeUseByParams(array $params)
 * @method getCountryListByParams(array $params)
 * @method getWatcherListByParams(array $params)
 * @method getGroupImHistoryByParams(array $params)
 * @method getAreaTreeByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取七牛云上传token
     *
     * @param  string $dirRule 记录数据 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function getUploadToken (string $dirRule = 'default') {
        return self::getClass()->getUploadToken([
            "dirRule" => $dirRule,
        ]);
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取hostInitPrefix
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHostInitPrefix () {
        return self::getClass()->getHostInitPrefix();
    }

    /**
     * 获取机构
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrgInfo () {
        return self::getClass()->getOrgInfo();
    }

    /**
     * 事件记录
     *
     * @param  int $eventId 事件id [ require true ]
     * @param  array $data 记录数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function eventLog (int $eventId, array $data = []) {
        return self::getClass()->eventLog([
            "eventId" => $eventId,
            "data" => $data,
        ]);
    }

    /**
     * 获取反馈标签s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFeedbackLabels () {
        return self::getClass()->getFeedbackLabels();
    }

    /**
     * 获取im票据
     *
     * @param  int $id 用户或者StaffId [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getImSign (int $id, string $type) {
        return self::getClass()->getImSign([
            "id" => $id,
            "type" => $type,
        ]);
    }

    /**
     * 根据code绑定用户
     *
     * @param  int $userId code [ require true ]
     * @param  string $code 小程序code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindUserWechatByCode (int $userId, string $code) {
        return self::getClass()->bindUserWechatByCode([
            "userId" => $userId,
            "code" => $code,
        ]);
    }

    /**
     * 获取贴图
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMappingPic (int $productId) {
        return self::getClass()->getMappingPic([
            "productId" => $productId,
        ]);
    }

    /**
     * 根据根节点id获取产品分类树
     *
     * @param  int $rootId 根分类节点id，获取整树所有则传0 [ require true ]
     * @param  bool $withProduct 是否需要产品列表,默认为false [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryTree (int $rootId, bool $withProduct = false) {
        return self::getClass()->getProductCategoryTree([
            "rootId" => $rootId,
            "withProduct" => $withProduct,
        ]);
    }

    /**
     * 获取裁剪用途
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeUse () {
        return self::getClass()->getPhotoSizeUse();
    }

    /**
     * 获取国家列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCountryList () {
        return self::getClass()->getCountryList();
    }

    /**
     * 看片师列表
     *
     * @param  mixed $conds  [ require false ]
     * @param  array $conds 查询条件 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWatcherList (array $conds = []) {
        return self::getClass()->getWatcherList([
            "conds" => $conds,
        ]);
    }

    /**
     * 获取聊天记录
     *
     * @param  string $groupId 查询条件 [ require true ]
     * @param  int $watchRecordId 看片单号id [ require false ]
     * @param  int $msgNumber 消息数 [ require false ]
     * @param  int $msgSeq 消息位置 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupImHistory (string $groupId, int $watchRecordId = null, int $msgNumber = 15, int $msgSeq = -1) {
        return self::getClass()->getGroupImHistory([
            "groupId" => $groupId,
            "watchRecordId" => $watchRecordId,
            "msgNumber" => $msgNumber,
            "msgSeq" => $msgSeq,
        ]);
    }

    /**
     * 获取区域信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAreaTree () {
        return self::getClass()->getAreaTree();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}