<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initRandomSequenceByParams(array $params)
 * @method getSByParams(array $params)
 * @method testSendWsByParams(array $params)
 * @method watchRecordRollbackByParams(array $params)
 * @method rQByParams(array $params)
 * @method flushAllByParams(array $params)
 * @method takeWatchingRecordByParams(array $params)
 * @method editWatchingRecordByParams(array $params)
 * @method pushQueueByParams(array $params)
 * @method changeProductsLimitCountByParams(array $params)
 * @method sendWatchRecordFinishByOrderNosByParams(array $params)
 * @method clearWatchRecordReplyCacheByParams(array $params)
 * @method updatePhotoFinishStatesByParams(array $params)
 * @method recoveryPhotosByParams(array $params)
 * @method recoveryRecordByParams(array $params)
 * @method uploadImChatAndCloseByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成当日日随机码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 回滚看片单
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getS (int $id) {
        return self::getClass()->getS([
            "id" => $id,
        ]);
    }

    /**
     * 获取伙伴信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function testSendWs () {
        return self::getClass()->testSendWs();
    }

    /**
     * 回滚订单
     *
     * @param  int $watchRecordId id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function watchRecordRollback (int $watchRecordId) {
        return self::getClass()->watchRecordRollback([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * 重推队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rQ () {
        return self::getClass()->rQ();
    }

    /**
     * 清空redis
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function flushAll () {
        return self::getClass()->flushAll();
    }

    /**
     * test-指派
     *
     * @param  int $watcherId watcherId [ require true ]
     * @param  int $recordId recordId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeWatchingRecord (int $watcherId, int $recordId) {
        return self::getClass()->takeWatchingRecord([
            "watcherId" => $watcherId,
            "recordId" => $recordId,
        ]);
    }

    /**
     * test-指派
     *
     * @param  int $watcherId watcherId [ require true ]
     * @param  int $recordId recordId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editWatchingRecord (int $watcherId, int $recordId) {
        return self::getClass()->editWatchingRecord([
            "watcherId" => $watcherId,
            "recordId" => $recordId,
        ]);
    }

    /**
     * test-推入队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushQueue () {
        return self::getClass()->pushQueue();
    }

    /**
     * test-修改产品
     *
     * @param  array $ids ids [ require true ]
     * @param  int $limitCount 限制产品照片数量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeProductsLimitCount (array $ids, int $limitCount) {
        return self::getClass()->changeProductsLimitCount([
            "ids" => $ids,
            "limitCount" => $limitCount,
        ]);
    }

    /**
     * temp - 补发看片单完成消息
     *
     * @param  array $orderNos 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendWatchRecordFinishByOrderNos (array $orderNos) {
        return self::getClass()->sendWatchRecordFinishByOrderNos([
            "orderNos" => $orderNos,
        ]);
    }

    /**
     * 清除在线看片自动回复缓存
     *
     * @param  int $recordId recordId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearWatchRecordReplyCache (int $recordId) {
        return self::getClass()->clearWatchRecordReplyCache([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 手动完成照片接口
     *
     * @param  array $photoIds 照片ids [ require true ]
     * @param  string $state 照片状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updatePhotoFinishStates (array $photoIds, string $state = 'finished') {
        return self::getClass()->updatePhotoFinishStates([
            "photoIds" => $photoIds,
            "state" => $state,
        ]);
    }

    /**
     * 恢复被删除的照片
     *
     * @param  array $photoIds 照片ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recoveryPhotos (array $photoIds) {
        return self::getClass()->recoveryPhotos([
            "photoIds" => $photoIds,
        ]);
    }

    /**
     * recoveryRecord
     *
     * @param  string $watchRecordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recoveryRecord (string $watchRecordNo) {
        return self::getClass()->recoveryRecord([
            "watchRecordNo" => $watchRecordNo,
        ]);
    }

    /**
     * 关闭并上传聊天信息
     *
     * @param  int $watchRecordId 看片单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function uploadImChatAndClose (int $watchRecordId) {
        return self::getClass()->uploadImChatAndClose([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}