<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotosByRecordIdByParams(array $params)
 * @method saveFeedbackRecordByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\SaveFeedbackPhoto $params)
 * @method feedbackByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\FeedbackPhoto $params)
 * @method batchFeedbackByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchFeedbackCmd $params)
 * @method satisfiedByParams(array $params)
 * @method batchSatisfiedByParams(array $params)
 * @method submitOtherInfoByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchOtherInfoCmd $params)
 * @method cropFormatByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Photo\FormatCmd $params)
 * @method readPhotoByParams(array $params)
 * @method getUnReadUpdatePhotoByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据看片单获取照片信息
     *
     * @param  int $recordId 看片记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotosByRecordId (int $recordId) {
        return self::getClass()->getPhotosByRecordId([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 保存反馈信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\SaveFeedbackPhoto $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveFeedbackRecord (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\SaveFeedbackPhoto $cmd) {
        return self::getClass()->saveFeedbackRecord($cmd);
    }


    /**
     * 创建反馈
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\FeedbackPhoto $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function feedback (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\FeedbackPhoto $cmd) {
        return self::getClass()->feedback($cmd);
    }


    /**
     * 批量反馈
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchFeedbackCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function batchFeedback (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchFeedbackCmd $cmd) {
        return self::getClass()->batchFeedback($cmd);
    }


    /**
     * 照片满意
     *
     * @param  int $id 照片id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function satisfied (int $id) {
        return self::getClass()->satisfied([
            "id" => $id,
        ]);
    }

    /**
     * 照片满意
     *
     * @param  array $ids 照片id数组 [ require true ]
     * @param  int $watchRecordId 看片单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSatisfied (array $ids, int $watchRecordId) {
        return self::getClass()->batchSatisfied([
            "ids" => $ids,
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * 提交其他处理信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchOtherInfoCmd $batchOtherInfoCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitOtherInfo (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchOtherInfoCmd $batchOtherInfoCmd) {
        return self::getClass()->submitOtherInfo($batchOtherInfoCmd);
    }


    /**
     * 图像算法排版
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Photo\FormatCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function cropFormat (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Photo\FormatCmd $cmd) {
        return self::getClass()->cropFormat($cmd);
    }


    /**
     * 标记照片已读 - v4.4
     *
     * @param  int $photoId 照片id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function readPhoto (int $photoId) {
        return self::getClass()->readPhoto([
            "photoId" => $photoId,
        ]);
    }

    /**
     * 获取未读照片数量 - v4.4
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $code 验证码 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function getUnReadUpdatePhoto () {
        return self::getClass()->getUnReadUpdatePhoto([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'SmallProgram\My\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'SmallProgram\My\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}