<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Pbc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookStartPictureOnlineByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\PBC\PbcOrderStartWatchOnlineMsg $params)
 */
class PbcWatch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hookStartPictureOnline
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Objects\PBC\PbcOrderStartWatchOnlineMsg $msg
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStartPictureOnline (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\PBC\PbcOrderStartWatchOnlineMsg $msg) {
        return self::getClass()->hookStartPictureOnline($msg);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Pbc\PbcWatch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Pbc\PbcWatch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}