<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method editByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 */
class ShortcutPhrase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片师快捷短语增加
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 看片师快捷短语编辑
     *
     * @support  string $content 内容 [ require true ]
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * 看片师快捷短语删除
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 看片师快捷短语列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Staff\ShortcutPhrase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Staff\ShortcutPhrase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}