<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createHistoryPhotoByParams(array $params)
 * @method batchCreateHistoryPhotoByParams(array $params)
 * @method batchCreateOtherCompletePhotoByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Photo\BatchCreateOtherPhotosCmd $params)
 * @method batchDeleteOtherCompletePhotoByParams(array $params)
 * @method readHistoryRecordByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片师上传修片信息
     *
     * @param  int $photoId 照片 id [ require true ]
     * @param  string $path 照片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createHistoryPhoto (int $photoId, string $path) {
        return self::getClass()->createHistoryPhoto([
            "photoId" => $photoId,
            "path" => $path,
        ]);
    }

    /**
     * 看片师批量上传修片信息
     *
     * @param  array $photoArray 修片数组[[&#039;photo_id&#039; =&gt; 1, &#039;path&#039; =&gt; &#039;www&#039;,],[&#039;photo_id&#039; =&gt; 2, &#039;path&#039; =&gt; &#039;www2&#039;,]] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreateHistoryPhoto (array $photoArray) {
        return self::getClass()->batchCreateHistoryPhoto([
            "photoArray" => $photoArray,
        ]);
    }

    /**
     * 看片师-上传其他照片
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Photo\BatchCreateOtherPhotosCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreateOtherCompletePhoto (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Photo\BatchCreateOtherPhotosCmd $cmd) {
        return self::getClass()->batchCreateOtherCompletePhoto($cmd);
    }


    /**
     * 看片师-删除其他成片
     *
     * @param  int $watchRecordId 看片单id [ require true ]
     * @param  array $otherPhotoIds 其他成片id数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDeleteOtherCompletePhoto (int $watchRecordId, array $otherPhotoIds) {
        return self::getClass()->batchDeleteOtherCompletePhoto([
            "watchRecordId" => $watchRecordId,
            "otherPhotoIds" => $otherPhotoIds,
        ]);
    }

    /**
     * 已读反馈记录
     *
     * @param  int $historyId 反馈记录id [ require true ]
     * @param  string $historyUUID 反馈记录uuid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readHistoryRecord (int $historyId, string $historyUUID) {
        return self::getClass()->readHistoryRecord([
            "historyId" => $historyId,
            "historyUUID" => $historyUUID,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}