<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method debugByParams(array $params)
 * @method getPhotoByParams(array $params)
 * @method pbcDebugByParams(array $params)
 * @method getGroupImHistoryByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单分析
     *
     * @param  string $orderNo orderNo [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function debug (string $orderNo) {
        return self::getClass()->debug([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 订单分析
     *
     * @param  string $watchRecordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhoto (string $watchRecordNo) {
        return self::getClass()->getPhoto([
            "watchRecordNo" => $watchRecordNo,
        ]);
    }

    /**
     * 订单分析-照片中台
     *
     * @param  string $orderNo orderNo [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pbcDebug (string $orderNo) {
        return self::getClass()->pbcDebug([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 订单分析-照片中台
     *
     * @param  string $orderNo orderNo [ require false ]
     * @param  string $watchRecordNo watchRecordNo [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupImHistory (string $orderNo = '', string $watchRecordNo = '') {
        return self::getClass()->getGroupImHistory([
            "orderNo" => $orderNo,
            "watchRecordNo" => $watchRecordNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}