<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addRecordToOrderByParams(array $params)
 * @method changePostInfoByParams(array $params)
 * @method closeByParams(array $params)
 * @method deleteByParams(array $params)
 * @method deleteRecordPhotosByParams(array $params)
 * @method getStaffOnlineInfoByParams(array $params)
 * @method deleteTemplateByParams(array $params)
 * @method canChooseCropOrMappingOrSquareByParams(array $params)
 * @method hasTakenByParams(array $params)
 * @method getSearchCountByParams(array $params)
 * @method getWatchRecordListByParams(array $params)
 * @method getByTakeTypeAndTakeStateByParams(array $params)
 * @method detailByParams(array $params)
 * @method getPhotosByIdsByParams(array $params)
 */
class WatchRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 为外部订单新增看片单
     *
     * @param  string $outsideNo 外部订单号 [ require true ]
     * @param  int $orgId 机构id [ require true ]
     * @param  mixed $extends 拓展字段 [ require true ]
     * @param  array $photos photos [ require true ]
     * @param  bool $needConfirm 需要确认 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function addRecordToOrder (string $outsideNo, int $orgId, array $photos, $extends = [], bool $needConfirm = false) {
        return self::getClass()->addRecordToOrder([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
            "photos" => $photos,
            "extends" => $extends,
            "needConfirm" => $needConfirm,
        ]);
    }

    /**
     * 修改取片信息
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $takeType 取片方式 [ require false ]
     * @param  string $takeRemark 取片备注 [ require false ]
     * @param  mixed $postInfo 取片信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePostInfo (string $recordNo, $postInfo = [], string $takeType = null, string $takeRemark = '') {
        return self::getClass()->changePostInfo([
            "recordNo" => $recordNo,
            "postInfo" => $postInfo,
            "takeType" => $takeType,
            "takeRemark" => $takeRemark,
        ]);
    }

    /**
     * 关闭看片单
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $message 关闭时通知到看片师的信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (string $recordNo, string $message = '看片单已被关闭') {
        return self::getClass()->close([
            "recordNo" => $recordNo,
            "message" => $message,
        ]);
    }

    /**
     * 删除看片单
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $recordNo) {
        return self::getClass()->delete([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 删除看片单数组
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  array $photoIds 照片id数组 [ require true ]
     * @param  string $type 原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteRecordPhotos (string $recordNo, array $photoIds, string $type = 'photographer_reload') {
        return self::getClass()->deleteRecordPhotos([
            "recordNo" => $recordNo,
            "photoIds" => $photoIds,
            "type" => $type,
        ]);
    }

    /**
     * 获取伙伴看片信息【1min缓存】
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffOnlineInfo (int $staffId) {
        return self::getClass()->getStaffOnlineInfo([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 删除看片单占位图
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteTemplate (string $recordNo) {
        return self::getClass()->deleteTemplate([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 是否可以裁剪、贴图、宫格
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function canChooseCropOrMappingOrSquare (string $recordNo) {
        return self::getClass()->canChooseCropOrMappingOrSquare([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 标记取片
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hasTaken (int $id) {
        return self::getClass()->hasTaken([
            "id" => $id,
        ]);
    }

    /**
     * 获取搜索数量
     *
     * @param  int $outStoreId 外部门店id [ require true ]
     * @param  array $outsideNos 订单号s [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSearchCount (int $outStoreId, array $outsideNos = []) {
        return self::getClass()->getSearchCount([
            "outStoreId" => $outStoreId,
            "outsideNos" => $outsideNos,
        ]);
    }

    /**
     * 获取看片单列表-分页
     *
     * @param  int $outStoreId 外部门店id [ require true ]
     * @param  array $outsideNos 订单号s [ require false ]
     * @param  array $userIds 用户ids [ require false ]
     * @param  string $takeType 取片方式 [ require false ]
     * @param  string $takeState 取片状态 [ require false ]
     * @param  int $page 取片状态 [ require false ]
     * @param  int $pageSize 取片状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWatchRecordList (int $outStoreId, array $outsideNos = [], array $userIds = [], string $takeType = '', string $takeState = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getWatchRecordList([
            "outStoreId" => $outStoreId,
            "outsideNos" => $outsideNos,
            "userIds" => $userIds,
            "takeType" => $takeType,
            "takeState" => $takeState,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据取片方式和取片状态获取数据
     *
     * @param  string $takeType 取片方式 [ require false ]
     * @param  string $takeState 取片状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByTakeTypeAndTakeState (string $takeType = '', string $takeState = '') {
        return self::getClass()->getByTakeTypeAndTakeState([
            "takeType" => $takeType,
            "takeState" => $takeState,
        ]);
    }

    /**
     * 获取看片单详情
     *
     * @param  int $id 看片id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量下载
     *
     * @param  array $ids 看片ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotosByIds (array $ids) {
        return self::getClass()->getPhotosByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\WatchRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\WatchRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}