<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method routeQueryV2ByParams(array $params)
 */
class SfExpress {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 路由查询
     *
     * @param  string $phone 手机号后4位 [ require true ]
     * @param  string $orderNumber 订单号 [ require true ]
     * @param  string $mailNumber 运单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function routeQueryV2 (string $phone, string $orderNumber, string $mailNumber) {
        return self::getClass()->routeQueryV2([
            "phone" => $phone,
            "orderNumber" => $orderNumber,
            "mailNumber" => $mailNumber,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'SmallProgram\My\SfExpress');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'SmallProgram\My\SfExpress');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}