<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method cancelOrderByParams(array $params)
 * @method routeQueryByParams(array $params)
 */
class SfExpress {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 统一下单
     *
     * @param  int $watchRecordId 看片单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrder (int $watchRecordId) {
        return self::getClass()->createOrder([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $watchRecordId 看片单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelOrder (int $watchRecordId) {
        return self::getClass()->cancelOrder([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * 路由查询
     *
     * @param  int $watchRecordId 看片单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function routeQuery (int $watchRecordId) {
        return self::getClass()->routeQuery([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\SfExpress');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\SfExpress');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}