<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkFirstWatchByParams(array $params)
 * @method detailByParams(array $params)
 * @method saveWatchTypeByParams(array $params)
 * @method getWatchRecordsByPhoneWithCodeByParams(array $params)
 * @method saveTakeTypeByParams(array $params)
 * @method getTakeTypeByParams(array $params)
 * @method banReplyByParams(array $params)
 * @method replyByParams(array $params)
 * @method getRecordWatcherWorkStateByParams(array $params)
 * @method getRecordPositionByParams(array $params)
 */
class WatchRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检查是否为第一次看片
     *
     * @param  int $watchRecordId 看片单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkFirstWatch (int $watchRecordId) {
        return self::getClass()->checkFirstWatch([
            "watchRecordId" => $watchRecordId,
        ]);
    }

    /**
     * 根据看片[序列号/id]获取看片单信息
     *
     * @support  int $id 看片记录id [ require false ]
     * @support  string $recordNo 看片序列号 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 保存看片方式
     *
     * @param  int $id 看片记录id [ require true ]
     * @param  string $watchType 看片方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveWatchType (int $id, string $watchType) {
        return self::getClass()->saveWatchType([
            "id" => $id,
            "watchType" => $watchType,
        ]);
    }

    /**
     * 根据手机号＋验证码或者微信登录, 获取看片单列表
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $code 验证码 [ require false ]
     * @param  string $outsideNo 外部单号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWatchRecordsByPhoneWithCode (string $outsideNo = null, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getWatchRecordsByPhoneWithCode([
            "outsideNo" => $outsideNo,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 保存取片方式
     *
     * @param  int $id 看片记录id [ require true ]
     * @support  string $takeType 取片方式 [ require false ]
     * @support  string $takeRemark 取片备注 [ require false ]
     * @support  mixed $postInfo 邮寄地址 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveTakeType (int $id) {
        return self::getClass()->saveTakeType([
            "id" => $id,
        ]);
    }

    /**
     * 获取取片方式
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTakeType (int $id) {
        return self::getClass()->getTakeType([
            "id" => $id,
        ]);
    }

    /**
     * 看片单禁止自动回复(不再提示)
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function banReply (int $id) {
        return self::getClass()->banReply([
            "id" => $id,
        ]);
    }

    /**
     * 看片单自动回复
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reply (int $id) {
        return self::getClass()->reply([
            "id" => $id,
        ]);
    }

    /**
     * 获取看片单对应看片师工作状态
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRecordWatcherWorkState (int $id) {
        return self::getClass()->getRecordWatcherWorkState([
            "id" => $id,
        ]);
    }

    /**
     * 获取看片单对应队列位置
     *
     * @param  int $id 看片记录id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getRecordPosition (int $id) {
        return self::getClass()->getRecordPosition([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'SmallProgram\My\WatchRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'SmallProgram\My\WatchRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}