<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addPhotoToRecordByParams(array $params)
 * @method recoverApprovedByParams(array $params)
 * @method deleteByParams(array $params)
 * @method satisfiedByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 为看片流水增加照片-v2.0.0
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPhotoToRecord (string $recordNo, array $photos) {
        return self::getClass()->addPhotoToRecord([
            "recordNo" => $recordNo,
            "photos" => $photos,
        ]);
    }

    /**
     * 覆盖其他成片
     *
     * @param  int $photoId 照片id [ require true ]
     * @param  string $approvedPath 成片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverApproved (int $photoId, string $approvedPath) {
        return self::getClass()->recoverApproved([
            "photoId" => $photoId,
            "approvedPath" => $approvedPath,
        ]);
    }

    /**
     * 删除照片-v2.0.0
     *
     * @param  int $photoId 照片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $photoId) {
        return self::getClass()->delete([
            "photoId" => $photoId,
        ]);
    }

    /**
     * 照片满意
     *
     * @param  int $id 照片id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function satisfied (int $id) {
        return self::getClass()->satisfied([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}