<?php
namespace Mainto\Bridge\Enums\ProjectPictureOnline\Watch\Photo;

class PhotoExtendEnum {
    /**
     * 裁剪信息
     */
    const CROP_INFO = 'crop_info';
    const CROP_INFO_RATIO = 'ratio';
    const CROP_INFO_LOCATION = 'location';
    const CROP_INFO_BASE_WIDTH = 'baseWidth';
    const CROP_INFO_CHECK_NAME = 'checkName';
    const CROP_INFO_CHECK_ID = 'checkId';
    const CROP_INFO_MAP = [0 => 'ratio',1 => 'location',2 => 'baseWidth',3 => 'checkName'];
    /**
     * 是否需要其他照片版本
     */
    const NEED_OTHER_PHOTO = 'need_other_photo';
    /**
     * 是否验证需要裁剪
     */
    const NEED_CROP_PHOTO = 'need_crop_photo';
    /**
     * 是否验证需要贴图
     */
    const NEED_MAPPING_PHOTO = 'need_mapping_photo';
    /**
     * 是否验证需要宫格
     */
    const NEED_SQUARE_PHOTO = 'need_square_photo';
    /**
     * 验证是否可以裁剪
     */
    const CAN_CROP = 'can_crop';
    /**
     * 验证是否可以贴图
     */
    const CAN_MAPPING = 'can_mapping';
    /**
     * 验证是否可以宫格
     */
    const CAN_SQUARE = 'can_square';
    /**
     * 贴图照片
     */
    const MAPPING_PHOTO = 'mapping_photo';
    /**
     * 其他照片s
     */
    const OTHER_PHOTOS = 'other_photos';
    /**
     * 其他照片[[]]
path 路径
userSelf 是否为用户自己裁剪照
checkName 裁剪尺寸名
     */
    const OTHER_PHOTOS_KEYS = [0 => 'path',1 => 'userSelf',2 => 'checkName'];
    const OTHER_PHOTO_PATH = 'path';
    const OTHER_PHOTO_USER_SELF = 'userSelf';
    const OTHER_PHOTO_CHECK_NAME = 'checkName';
    const OTHER_PHOTO_CHECK_ID = 'checkId';
    /**
     * 产品信息
     */
    const PRODUCT_INFO = 'product_info';
    /**
     * 修片师信息
     */
    const RETOUCHER_INFO = 'retoucher_info';
    const MAP = [0 => 'crop_info',1 => 'need_other_photo'];
    /**
     * 裁剪模板id
模板json目前保存在前端
     */
    const CROP_TEMPLATE_ID = 'crop_template_id';
    const CROP_TEMPLATE_MAP = [0 => ['id' => 1,'name' => '证件照裁剪模板'],1 => ['id' => 2,'name' => '签证照裁剪模板'],2 => ['id' => 3,'name' => '结婚登记照裁剪模板']];
    /**
     * 水印类型
模板json目前保存在前端
     */
    const WATERMARK_TYPE = 'watermark_type';
    const WATERMARK_TYPE_HIMO = 'himo';
    const WATERMARK_TYPE_SHOW_PIC = 'showpic';
    const WATERMARK_MAP = [0 => 'himo',1 => 'showpic'];
    const ORG_TO_WATERMARK_CHANGE = [1 => 'himo',11 => 'showpic'];
    /**
     * 云端照片id
     */
    const CLOUD_PHOTO_ID = 'cloud_photo_id';
    /**
     * 云端流水号
     */
    const CLOUD_STREAM_NUM = 'cloud_stream_num';
    /**
     * 摄影备注
     */
    const PHOTOGRAPHY_NOTE = 'photography_note';
    /**
     * 跳过裁剪
     */
    const SKIP_CROP = 'skip_crop';
    /**
     * 修片备注
     */
    const TRIM_NOTE = 'trim_note';
    /**
     * 摄影底色
     */
    const PHOTOGRAPHY_COLOR = 'photography_color';
    /**
     * 修图底色
     */
    const RETOUCH_COLOR = 'retouch_color';
    const TEXTURE_NAME = 'texture_name';
    /**
     * 摄影注意事项
     */
    const PHOTOGRAPHY_REMARK = 'photography_remark';
    /**
     * 修图注意事项
     */
    const RETOUCH_REMARK = 'retouch_remark';
    /**
     * 上一个状态
     */
    const LAST_STATE = 'last_state';
}