<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Operator;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductCategoryByParams(array $params)
 * @method addProductByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Operator\AddProduct $params)
 * @method getProductCategoryListByParams(array $params)
 * @method getProductDetailByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method getNotOnlineProductListByParams(array $params)
 * @method getAllOnlineProductByParams(array $params)
 * @method editOnlineProductByParams(array $params)
 * @method enableOnlineProductByParams(array $params)
 * @method disableOnlineProductByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加产品类别
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addProductCategory (string $name) {
        return self::getClass()->addProductCategory([
            "name" => $name,
        ]);
    }

    /**
     * 添加看片产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Operator\AddProduct $addProduct
     * @throws  \Exception
     * @return  bool
     */
    public static function addProduct (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\Operator\AddProduct $addProduct) {
        return self::getClass()->addProduct($addProduct);
    }


    /**
     * 获取在线看片产品类别列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryList () {
        return self::getClass()->getProductCategoryList();
    }

    /**
     * 获取在线看片产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductDetail (int $id) {
        return self::getClass()->getProductDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取在线看片产品列表
     *
     * @param  array $productIds 产品ids [ require false ]
     * @param  array $categoryIds 产品类别id [ require false ]
     * @param  array $modules 模块 [ require false ]
     * @param  int $page 产品类别id [ require false ]
     * @param  int $pageSize 产品类别id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductList (array $productIds = [], array $modules = [], array $categoryIds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductList([
            "productIds" => $productIds,
            "modules" => $modules,
            "categoryIds" => $categoryIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取不在在线看片产品列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getNotOnlineProductList () {
        return self::getClass()->getNotOnlineProductList();
    }

    /**
     * 获取所有在线看片产品
     *
     * @param  bool $onlyEnable 只需要启用 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllOnlineProduct (bool $onlyEnable = false) {
        return self::getClass()->getAllOnlineProduct([
            "onlyEnable" => $onlyEnable,
        ]);
    }

    /**
     * 编辑在线看片产品
     *
     * @param  int $id 产品id [ require true ]
     * @param  array $productCategoryIds 产品类别id [ require true ]
     * @param  array $mappingPath 贴图 [ require false ]
     * @support  int $limitPhotoCount 限制的照片张数 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editOnlineProduct (int $id, array $productCategoryIds, array $mappingPath = []) {
        return self::getClass()->editOnlineProduct([
            "id" => $id,
            "productCategoryIds" => $productCategoryIds,
            "mappingPath" => $mappingPath,
        ]);
    }

    /**
     * 开启在线看片产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enableOnlineProduct (int $id) {
        return self::getClass()->enableOnlineProduct([
            "id" => $id,
        ]);
    }

    /**
     * 禁用在线看片产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disableOnlineProduct (int $id) {
        return self::getClass()->disableOnlineProduct([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Operator\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Operator\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}