<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWatcherListByParams(array $params)
 * @method getWatcherPaginateByParams(array $params)
 * @method checkWatcherRegisterByParams(array $params)
 * @method addOrEditRoleByParams(array $params)
 * @method getRoleListByParams(array $params)
 * @method getRoleInfoByParams(array $params)
 * @method getStaffRoleInfoByParams(array $params)
 * @method getPermissionsByParams(array $params)
 * @method addOrEditStaffRoleOrPermissionByParams(array $params)
 * @method addOrEditStaffWithTakeConfigByParams(array $params)
 * @method getSelfStaffPermissionByParams(array $params)
 * @method getStaffPermissionByParams(array $params)
 * @method getStaffInfoByParams(array $params)
 * @method enableStaffByParams(array $params)
 * @method disableStaffByParams(array $params)
 * @method delRoleByParams(array $params)
 * @method exchangeStaffRecordByParams(array $params)
 * @method checkHasProcessingRecordByParams(array $params)
 * @method getStaffInfoWithTakeConfigByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片师列表
     *
     * @param  mixed $conds  [ require false ]
     * @param  array $conds 查询条件 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWatcherList (array $conds = []) {
        return self::getClass()->getWatcherList([
            "conds" => $conds,
        ]);
    }

    /**
     * 看片师分页
     *
     * @param  mixed $conds  [ require false ]
     * @param  array $conds 查询条件 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWatcherPaginate (array $conds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getWatcherPaginate([
            "conds" => $conds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 检查看片师注册逻辑
     *
     * @param  int $staffId staff id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWatcherRegister (int $staffId) {
        return self::getClass()->checkWatcherRegister([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 创建/编辑角色组
     *
     * @param  int $roleId 角色id [ require false ]
     * @param  string $title 角色名 [ require true ]
     * @param  array $permissionIds 权限ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOrEditRole (string $title, array $permissionIds, int $roleId = null) {
        return self::getClass()->addOrEditRole([
            "title" => $title,
            "permissionIds" => $permissionIds,
            "roleId" => $roleId,
        ]);
    }

    /**
     * 获取角色组列表
     *
     * @param  string $title 角色名 [ require false ]
     * @param  int $page page [ require false ]
     * @param  int $pageSize pageSize [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleList (string $title = '', int $page = 1, int $pageSize = 20) {
        return self::getClass()->getRoleList([
            "title" => $title,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取角色信息
     *
     * @param  int $roleId 角色组id [ require true ]
     * @param  bool $additionInfo 额外信息 是否有作用的伙伴 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRoleInfo (int $roleId, bool $additionInfo = false) {
        return self::getClass()->getRoleInfo([
            "roleId" => $roleId,
            "additionInfo" => $additionInfo,
        ]);
    }

    /**
     * 获取员工在线看片角色信息
     *
     * @param  int $staffId 获取staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffRoleInfo (int $staffId) {
        return self::getClass()->getStaffRoleInfo([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取所有权限
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissions () {
        return self::getClass()->getPermissions();
    }

    /**
     * 创建/编辑伙伴权限或角色组
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  int $roleId 角色id [ require false ]
     * @param  array $permissionIds 权限ids [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function addOrEditStaffRoleOrPermission (int $staffId, int $roleId = 0, array $permissionIds = []) {
        return self::getClass()->addOrEditStaffRoleOrPermission([
            "staffId" => $staffId,
            "roleId" => $roleId,
            "permissionIds" => $permissionIds,
        ]);
    }

    /**
     * 添加或编辑伙伴可接订单配置
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $type 类型 [ require false ]
     * @param  array $takeStoreIds 可接门店和可接机构 [ require false ]
     * @param  array $takeProductIds 可接产品 [ require false ]
     * @param  array $extends 可接产品 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addOrEditStaffWithTakeConfig (int $staffId, array $takeStoreIds = [], array $takeProductIds = [], array $extends = [], string $type = 'blue') {
        return self::getClass()->addOrEditStaffWithTakeConfig([
            "staffId" => $staffId,
            "takeStoreIds" => $takeStoreIds,
            "takeProductIds" => $takeProductIds,
            "extends" => $extends,
            "type" => $type,
        ]);
    }

    /**
     * 获取登录权限信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfStaffPermission () {
        return self::getClass()->getSelfStaffPermission();
    }

    /**
     * 获取指定伙伴权限信息
     *
     * @param  int $staffId 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffPermission (int $staffId) {
        return self::getClass()->getStaffPermission([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取伙伴im聊天签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffInfo () {
        return self::getClass()->getStaffInfo();
    }

    /**
     * 启用伙伴
     *
     * @param  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enableStaff (int $staffId) {
        return self::getClass()->enableStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 禁用伙伴
     *
     * @param  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disableStaff (int $staffId) {
        return self::getClass()->disableStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 删除角色
     *
     * @param  int $roleId 角色组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delRole (int $roleId) {
        return self::getClass()->delRole([
            "roleId" => $roleId,
        ]);
    }

    /**
     * 转交禁用帐号的看片单
     *
     * @param  int $staffId staffId [ require true ]
     * @param  int $exchangeId 交换 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function exchangeStaffRecord (int $staffId, int $exchangeId) {
        return self::getClass()->exchangeStaffRecord([
            "staffId" => $staffId,
            "exchangeId" => $exchangeId,
        ]);
    }

    /**
     * 检查是否有正在进行中的看片单
     *
     * @param  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkHasProcessingRecord (int $staffId) {
        return self::getClass()->checkHasProcessingRecord([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取伙伴和接单配置
     *
     * @param  int $id staffId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfoWithTakeConfig (int $id) {
        return self::getClass()->getStaffInfoWithTakeConfig([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Staff\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Staff\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}