<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotosByRecordIdByParams(array $params)
 * @method feedbackByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\FeedbackPhoto $params)
 * @method batchFeedbackByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchFeedbackCmd $params)
 * @method rollbackStateByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\RollbackStateCmd $params)
 * @method satisfiedByParams(array $params)
 * @method submitCropInfoByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据看片单获取照片信息
     *
     * @param  int $recordId 看片记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotosByRecordId (int $recordId) {
        return self::getClass()->getPhotosByRecordId([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 创建反馈
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\FeedbackPhoto $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function feedback (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\FeedbackPhoto $cmd) {
        return self::getClass()->feedback($cmd);
    }


    /**
     * 批量反馈
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchFeedbackCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function batchFeedback (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\BatchFeedbackCmd $cmd) {
        return self::getClass()->batchFeedback($cmd);
    }


    /**
     * 批量反馈
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\RollbackStateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function rollbackState (\Mainto\Bridge\Structs\ProjectPictureOnline\Cmd\Photo\RollbackStateCmd $cmd) {
        return self::getClass()->rollbackState($cmd);
    }


    /**
     * 照片满意
     *
     * @param  int $id 照片id [ require true ]
     * @param  bool $needOtherPhotos 是否需要其他裁剪片 [ require false ]
     * @param  string $mappingPath 贴图地址 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function satisfied (int $id, bool $needOtherPhotos = false, string $mappingPath = '') {
        return self::getClass()->satisfied([
            "id" => $id,
            "needOtherPhotos" => $needOtherPhotos,
            "mappingPath" => $mappingPath,
        ]);
    }

    /**
     * 提交裁剪信息
     *
     * @param  int $id 照片id [ require true ]
     * @param  array $cropInfo 裁剪信息 [ require true ]
     * @param  bool $needOtherPhotos 是否需要其他裁剪片 [ require false ]
     * @param  string $mappingPath 贴图地址 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submitCropInfo (int $id, array $cropInfo, bool $needOtherPhotos = false, string $mappingPath = '') {
        return self::getClass()->submitCropInfo([
            "id" => $id,
            "cropInfo" => $cropInfo,
            "needOtherPhotos" => $needOtherPhotos,
            "mappingPath" => $mappingPath,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'SmallProgram\My\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'SmallProgram\My\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}