<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotoSizeByIdsByParams(array $params)
 * @method getPhotoSizeTypeIdsByProductIdsByParams(array $params)
 */
class PhotoSize {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据id获取打印尺寸
     *
     * @param  array $ids 看片单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeByIds (array $ids) {
        return self::getClass()->getPhotoSizeByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据产品ids获取打印尺寸类型id
     *
     * @param  array $productIds 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeTypeIdsByProductIds (array $productIds) {
        return self::getClass()->getPhotoSizeTypeIdsByProductIds([
            "productIds" => $productIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\PhotoSize');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\PhotoSize');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}