<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Operator;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addOnlineStoreByParams(array $params)
 * @method editOnlineStoreByParams(array $params)
 * @method getOnlineStoreListByParams(array $params)
 * @method getNotOnlineStoreListByParams(array $params)
 * @method getAllOnlineStoreByParams(array $params)
 * @method getOnlineStoreDetailByParams(array $params)
 * @method enableOnlineStoreByParams(array $params)
 * @method disableOnlineStoreByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加在线看片门店
     *
     * @param  string $module 所属模块 [ require true ]
     * @param  array $productIds 名称 [ require true ]
     * @param  bool $onlySelfTake 名称 [ require true ]
     * @param  int $outStoreId 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addOnlineStore (int $outStoreId, string $module, bool $onlySelfTake, array $productIds) {
        return self::getClass()->addOnlineStore([
            "outStoreId" => $outStoreId,
            "module" => $module,
            "onlySelfTake" => $onlySelfTake,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 编辑在线看片门店
     *
     * @param  string $module 所属模块 [ require true ]
     * @param  array $productIds 名称 [ require true ]
     * @param  bool $onlySelfTake 名称 [ require true ]
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editOnlineStore (int $id, string $module, bool $onlySelfTake, array $productIds) {
        return self::getClass()->editOnlineStore([
            "id" => $id,
            "module" => $module,
            "onlySelfTake" => $onlySelfTake,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 在线看片门店列表
     *
     * @param  array $ids 门店 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页码 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineStoreList (array $ids = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getOnlineStoreList([
            "ids" => $ids,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取不在在线看片门店列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getNotOnlineStoreList () {
        return self::getClass()->getNotOnlineStoreList();
    }

    /**
     * 获取所有在线看片门店列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllOnlineStore () {
        return self::getClass()->getAllOnlineStore();
    }

    /**
     * 获取在线看片门店信息
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineStoreDetail (int $id) {
        return self::getClass()->getOnlineStoreDetail([
            "id" => $id,
        ]);
    }

    /**
     * 开启在线看片门店
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enableOnlineStore (int $id) {
        return self::getClass()->enableOnlineStore([
            "id" => $id,
        ]);
    }

    /**
     * 禁用在线看片门店
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disableOnlineStore (int $id) {
        return self::getClass()->disableOnlineStore([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Operator\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Operator\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}