<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\OutsideOrder $params)
 * @method getLastWatchRecordByParams(array $params)
 * @method getOrderWithWatchRecordsByParams(array $params)
 * @method getOrderListWithWatchRecordsByParams(array $params)
 */
class OutsideOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增外部订单-v2.0.0
     *
     * @var  \Mainto\Bridge\Structs\ProjectPictureOnline\Objects\OutsideOrder $outsideOrder
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\ProjectPictureOnline\Objects\OutsideOrder $outsideOrder) {
        return self::getClass()->create($outsideOrder);
    }


    /**
     * 获取订单最后一条看片记录-v2.0.0
     *
     * @param  string $outsideNo 外部订单号 [ require true ]
     * @param  int $orgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastWatchRecord (string $outsideNo, int $orgId) {
        return self::getClass()->getLastWatchRecord([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
        ]);
    }

    /**
     * 获取订单看片单列表接口
     *
     * @param  string $outsideNo 外部订单号 [ require true ]
     * @param  int $orgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderWithWatchRecords (string $outsideNo, int $orgId) {
        return self::getClass()->getOrderWithWatchRecords([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
        ]);
    }

    /**
     * 获取订单列表看片单列表接口
     *
     * @param  array $outsideNos 外部订单号数组 [ require true ]
     * @param  int $orgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderListWithWatchRecords (array $outsideNos, int $orgId) {
        return self::getClass()->getOrderListWithWatchRecords([
            "outsideNos" => $outsideNos,
            "orgId" => $orgId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\OutsideOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\OutsideOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}