<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Operator;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addOnlineProductCategoryByParams(array $params)
 * @method addOnlineProductByParams(array $params)
 * @method getOnlineProductCategoryListByParams(array $params)
 * @method getOnlineProductDetailByParams(array $params)
 * @method getOnlineProductListByParams(array $params)
 * @method getNotOnlineProductListByParams(array $params)
 * @method getAllOnlineProductByParams(array $params)
 * @method editOnlineProductByParams(array $params)
 * @method enableOnlineProductByParams(array $params)
 * @method disableOnlineProductByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加产品类别
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addOnlineProductCategory (string $name) {
        return self::getClass()->addOnlineProductCategory([
            "name" => $name,
        ]);
    }

    /**
     * 添加在线看片产品
     *
     * @param  array $products 产品ids [ require true ]
     * @param  int $categoryId 产品类别id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addOnlineProduct (int $categoryId, array $products) {
        return self::getClass()->addOnlineProduct([
            "categoryId" => $categoryId,
            "products" => $products,
        ]);
    }

    /**
     * 获取在线看片产品类别列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineProductCategoryList () {
        return self::getClass()->getOnlineProductCategoryList();
    }

    /**
     * 获取在线看片产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineProductDetail (int $id) {
        return self::getClass()->getOnlineProductDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取在线看片产品列表
     *
     * @param  array $productIds 产品ids [ require true ]
     * @param  array $categoryIds 产品类别id [ require true ]
     * @param  int $page 产品类别id [ require true ]
     * @param  int $pageSize 产品类别id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineProductList (array $productIds, array $categoryIds, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getOnlineProductList([
            "productIds" => $productIds,
            "categoryIds" => $categoryIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取不在在线看片产品列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getNotOnlineProductList () {
        return self::getClass()->getNotOnlineProductList();
    }

    /**
     * 获取所有在线看片产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllOnlineProduct () {
        return self::getClass()->getAllOnlineProduct();
    }

    /**
     * 编辑在线看片产品
     *
     * @param  int $id 产品id [ require true ]
     * @param  int $productCategoryId 产品类别id [ require true ]
     * @param  array $mappingPath 贴图 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editOnlineProduct (int $id, int $productCategoryId, array $mappingPath = []) {
        return self::getClass()->editOnlineProduct([
            "id" => $id,
            "productCategoryId" => $productCategoryId,
            "mappingPath" => $mappingPath,
        ]);
    }

    /**
     * 开启在线看片产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enableOnlineProduct (int $id) {
        return self::getClass()->enableOnlineProduct([
            "id" => $id,
        ]);
    }

    /**
     * 禁用在线看片产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disableOnlineProduct (int $id) {
        return self::getClass()->disableOnlineProduct([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Operator\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Operator\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}