<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initRandomSequenceByParams(array $params)
 * @method autoFinishWatchRecordByParams(array $params)
 * @method getQByParams(array $params)
 * @method getSByParams(array $params)
 * @method rQByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成当日日随机码
     *
     * @throws  \Exception
     * @return  array
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 自动完成37天以前的单据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoFinishWatchRecord () {
        return self::getClass()->autoFinishWatchRecord();
    }

    /**
     * 获取当前队列信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getQ () {
        return self::getClass()->getQ();
    }

    /**
     * 获取伙伴信息
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getS (int $id) {
        return self::getClass()->getS([
            "id" => $id,
        ]);
    }

    /**
     * 重推队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rQ () {
        return self::getClass()->rQ();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}