<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addRecordToOrderByParams(array $params)
 * @method changePostInfoByParams(array $params)
 * @method closeByParams(array $params)
 * @method deleteByParams(array $params)
 */
class WatchRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 为外部订单新增看片单
     *
     * @param  string $outsideNo 外部订单号 [ require true ]
     * @param  int $orgId 机构id [Original type uint] [ require true ]
     * @param  array $extends 拓展字段 [ require true ]
     * @support  bool $extends.skip_take_photo 跳过取片 
     * @param  array $photos photos [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addRecordToOrder (string $outsideNo, int $orgId, array $photos, array $extends) {
        return self::getClass()->addRecordToOrder([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
            "photos" => $photos,
            "extends" => $extends,
        ]);
    }

    /**
     * 修改取片信息
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $takeType 取片方式 [ require true ]
     * @param  array $postInfo 取片信息 [ require true ]
     * @support  string $postInfo.province 省 [ require true ]
     * @support  string $postInfo.city 市 [ require true ]
     * @support  string $postInfo.area 区 [ require true ]
     * @support  string $postInfo.detail 详细地址 [ require true ]
     * @support  string $postInfo.name 姓名 [ require true ]
     * @support  string $postInfo.phone 电话 [ require true ]
     * @support  string $postInfo.post_num 邮编 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePostInfo (string $recordNo, array $postInfo, string $takeType = NULL) {
        return self::getClass()->changePostInfo([
            "recordNo" => $recordNo,
            "postInfo" => $postInfo,
            "takeType" => $takeType,
        ]);
    }

    /**
     * 关闭看片单
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (string $recordNo) {
        return self::getClass()->close([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 删除看片单
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $recordNo) {
        return self::getClass()->delete([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\WatchRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\WatchRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}