<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method offlineWatchRecordFinishByParams(array $params)
 * @method offlineWatchRecordBindByParams(array $params)
 * @method delayFinishWatchRecordByParams(array $params)
 * @method delayFinishWatchRecordNoticeByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片单线下看片完成
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $finishAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offlineWatchRecordFinish (string $recordNo, string $finishAt) {
        return self::getClass()->offlineWatchRecordFinish([
            "recordNo" => $recordNo,
            "finishAt" => $finishAt,
        ]);
    }

    /**
     * 看片单在线下接单
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $bindAt  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offlineWatchRecordBind (string $recordNo, string $bindAt) {
        return self::getClass()->offlineWatchRecordBind([
            "recordNo" => $recordNo,
            "bindAt" => $bindAt,
        ]);
    }

    /**
     * 照片已经全部确认，裁剪完的看片单4h自动完成
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delayFinishWatchRecord (string $recordNo) {
        return self::getClass()->delayFinishWatchRecord([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 照片已经全部确认，裁剪完的看片单3h提醒
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delayFinishWatchRecordNotice (string $recordNo) {
        return self::getClass()->delayFinishWatchRecordNotice([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}