<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getLastWatchRecordByParams(array $params)
 * @method getOrderWithWatchRecordsByParams(array $params)
 */
class OutsideOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增外部订单-v2.0.0
     *
     * @support  string $outsideNo 外部订单号 [ require true ]
     * @support  int $userId 用户id [Original type uint] [ require true ]
     * @support  int $orgId 机构id [Original type uint] [ require true ]
     * @support  array $extends.store_info 门店信息 
     * @support  int $extends.store_info.id 门店信息 [Original type uint] 
     * @support  string $extends.store_info.name 门店信息 
     * @support  string $extends.store_info.phone 门店信息.门店电话 
     * @support  string $extends.dresser_note 化妆师备注 
     * @support  array $extends.photographer_info 摄影师信息 
     * @support  string $extends.photographer_info.name 摄影师名称 
     * @support  int $extends.photographer_info.id 摄影师id [Original type uint] 
     * @support  string $extends.photographer_info.nickname 摄影师昵称 
     * @support  string $extends.order_note 订单备注 
     * @support  bool $extends.only_online_watch 订单备注 [ require true ]
     * @support  array $extends 扩展字段 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取订单最后一条看片记录-v2.0.0
     *
     * @param  string $outsideNo 外部订单号 [ require true ]
     * @param  int $orgId 机构id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastWatchRecord (string $outsideNo, int $orgId) {
        return self::getClass()->getLastWatchRecord([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
        ]);
    }

    /**
     * 获取订单看片单列表接口
     *
     * @param  string $outsideNo 外部订单号 [ require true ]
     * @param  int $orgId 机构id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderWithWatchRecords (string $outsideNo, int $orgId) {
        return self::getClass()->getOrderWithWatchRecords([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\OutsideOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\OutsideOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}