<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\WatchRecord;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method confirmByParams(array|WatchRecordOperate\Confirm\WatcherConfirmCmd $params)
 */
class WatchRecordOperate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * confirm
     *
     * @var  WatchRecordOperate\Confirm\WatcherConfirmCmd $cmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm (WatchRecordOperate\Confirm\WatcherConfirmCmd $cmd) {
        return self::getClass()->confirm($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'WatchRecord\WatchRecordOperate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'WatchRecord\WatchRecordOperate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}