<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addPhotoSizeTypeByParams(array|PhotoSize\AddPhotoSizeType\PhotoSizeType $params)
 * @method editPhotoSizeTypeByParams(array|PhotoSize\EditPhotoSizeType\EditPhotoSizeType $params)
 * @method getPhotoSizeTypeListByParams(array $params)
 * @method getPhotoSizeTypeDetailByParams(array $params)
 * @method addPhotoSizeByParams(array|PhotoSize\AddPhotoSize\PhotoSize $params)
 * @method editPhotoSizeByParams(array|PhotoSize\EditPhotoSize\EditPhotoSize $params)
 * @method getPhotoSizeListByParams(array $params)
 * @method getPhotoSizeDetailByParams(array $params)
 * @method delPhotoSizeByParams(array $params)
 * @method addFeedbackByParams(array|PhotoSize\AddFeedback\Feedback $params)
 * @method getFeedbackListByParams(array $params)
 * @method getFeedbackDetailByParams(array $params)
 * @method bindFeedbackByParams(array $params)
 * @method handleFeedbackByParams(array $params)
 */
class PhotoSize {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加尺寸类型
     *
     * @var  PhotoSize\AddPhotoSizeType\PhotoSizeType $photoSizeType $photoSizeType
     * @throws  \Exception
     * @return  int
     */
    public static function addPhotoSizeType (PhotoSize\AddPhotoSizeType\PhotoSizeType $photoSizeType) {
        return self::getClass()->addPhotoSizeType($photoSizeType);
    }


    /**
     * 修改尺寸类型
     *
     * @var  PhotoSize\EditPhotoSizeType\EditPhotoSizeType $photoSizeType $photoSizeType
     * @throws  \Exception
     * @return  int
     */
    public static function editPhotoSizeType (PhotoSize\EditPhotoSizeType\EditPhotoSizeType $photoSizeType) {
        return self::getClass()->editPhotoSizeType($photoSizeType);
    }


    /**
     * 获取尺寸类型列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeTypeList () {
        return self::getClass()->getPhotoSizeTypeList();
    }

    /**
     * 获取尺寸类型详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeTypeDetail (int $id) {
        return self::getClass()->getPhotoSizeTypeDetail([
            "id" => $id,
        ]);
    }

    /**
     * 添加尺寸
     *
     * @var  PhotoSize\AddPhotoSize\PhotoSize $photoSize $photoSize
     * @throws  \Exception
     * @return  int
     */
    public static function addPhotoSize (PhotoSize\AddPhotoSize\PhotoSize $photoSize) {
        return self::getClass()->addPhotoSize($photoSize);
    }


    /**
     * 修改尺寸
     *
     * @var  PhotoSize\EditPhotoSize\EditPhotoSize $photoSize $photoSize
     * @throws  \Exception
     * @return  int
     */
    public static function editPhotoSize (PhotoSize\EditPhotoSize\EditPhotoSize $photoSize) {
        return self::getClass()->editPhotoSize($photoSize);
    }


    /**
     * 获取尺寸列表
     *
     * @support  int $typeId 类型id [ require true ]
     * @support  array $useIds 用途 require false
     * @support  array $areaIds 地区id require false
     * @support  string $name 尺寸规格 require false
     * @support  string $areaType 地区类型 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 页数 require false
     * @throws  \Exception
     * @return  PhotoSize\GetPhotoSizeList\PhotoSize[]
     */
    public static function getPhotoSizeList () {
        return self::getClass()->getPhotoSizeList();
    }

    /**
     * 获取尺寸详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoSizeDetail (int $id) {
        return self::getClass()->getPhotoSizeDetail([
            "id" => $id,
        ]);
    }

    /**
     * 删除尺寸
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delPhotoSize (int $id) {
        return self::getClass()->delPhotoSize([
            "id" => $id,
        ]);
    }

    /**
     * 新增问题反馈
     *
     * @var  PhotoSize\AddFeedback\Feedback $feedback $feedback
     * @throws  \Exception
     * @return  int
     */
    public static function addFeedback (PhotoSize\AddFeedback\Feedback $feedback) {
        return self::getClass()->addFeedback($feedback);
    }


    /**
     * 查看问题反馈列表
     *
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  array $status 状态 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 页数 require false
     * @throws  \Exception
     * @return  PhotoSize\GetFeedbackList\Feedback[]
     */
    public static function getFeedbackList () {
        return self::getClass()->getFeedbackList();
    }

    /**
     * 查看问题反馈
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getFeedbackDetail (int $id) {
        return self::getClass()->getFeedbackDetail([
            "id" => $id,
        ]);
    }

    /**
     * 绑定问题反馈
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindFeedback (int $id) {
        return self::getClass()->bindFeedback([
            "id" => $id,
        ]);
    }

    /**
     * 处理问题反馈
     *
     * @param  int $id id [ require true ]
     * @param  string $replyContent id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleFeedback (int $id, string $replyContent) {
        return self::getClass()->handleFeedback([
            "id" => $id,
            "replyContent" => $replyContent,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\PhotoSize');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\PhotoSize');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}