<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addPhotoSizeTypeByParams(array|PhotoSize\AddPhotoSizeType\PhotoSizeType $params)
 * @method editPhotoSizeTypeByParams(array|PhotoSize\EditPhotoSizeType\PhotoSizeType $params)
 * @method getPhotoSizeTypeListByParams(array $params)
 * @method getPhotoSizeTypeDetailByParams(array $params)
 * @method addPhotoSizeByParams(array|PhotoSize\AddPhotoSize\PhotoSize $params)
 * @method editPhotoSizeByParams(array|PhotoSize\EditPhotoSize\PhotoSize $params)
 * @method getPhotoSizeListByParams(array $params)
 * @method getPhotoSizeDetailByParams(array $params)
 */
class PhotoSize {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加尺寸类型
     *
     * @var  PhotoSize\AddPhotoSizeType\PhotoSizeType $photoSizeType $photoSizeType
     * @throws  \Exception
     * @return  int
     */
    public static function addPhotoSizeType (PhotoSize\AddPhotoSizeType\PhotoSizeType $photoSizeType) {
        return self::getClass()->addPhotoSizeType($photoSizeType);
    }


    /**
     * 修改尺寸类型
     *
     * @var  PhotoSize\EditPhotoSizeType\PhotoSizeType $photoSizeType $photoSizeType
     * @throws  \Exception
     * @return  int
     */
    public static function editPhotoSizeType (PhotoSize\EditPhotoSizeType\PhotoSizeType $photoSizeType) {
        return self::getClass()->editPhotoSizeType($photoSizeType);
    }


    /**
     * 获取尺寸类型列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeTypeList () {
        return self::getClass()->getPhotoSizeTypeList();
    }

    /**
     * 获取尺寸类型详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeTypeDetail (int $id) {
        return self::getClass()->getPhotoSizeTypeDetail([
            "id" => $id,
        ]);
    }

    /**
     * 添加尺寸类型
     *
     * @var  PhotoSize\AddPhotoSize\PhotoSize $photoSize $photoSize
     * @throws  \Exception
     * @return  int
     */
    public static function addPhotoSize (PhotoSize\AddPhotoSize\PhotoSize $photoSize) {
        return self::getClass()->addPhotoSize($photoSize);
    }


    /**
     * 修改尺寸类型
     *
     * @var  PhotoSize\EditPhotoSize\PhotoSize $photoSize $photoSize
     * @throws  \Exception
     * @return  int
     */
    public static function editPhotoSize (PhotoSize\EditPhotoSize\PhotoSize $photoSize) {
        return self::getClass()->editPhotoSize($photoSize);
    }


    /**
     * 获取尺寸列表
     *
     * @support  int $typeId 类型id [ require true ]
     * @support  array $useIds 用途 [ require true ]
     * @support  array $areaIds 地区id require false
     * @support  string $areaType 地区类型 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 页数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeList () {
        return self::getClass()->getPhotoSizeList();
    }

    /**
     * 获取尺寸详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoSizeDetail (int $id) {
        return self::getClass()->getPhotoSizeDetail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\PhotoSize');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\PhotoSize');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}