<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUploadTokenByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getHostInitPrefixByParams(array $params)
 * @method getOrgInfoByParams(array $params)
 * @method eventLogByParams(array $params)
 * @method getFeedbackLabelsByParams(array $params)
 * @method getImSignByParams(array $params)
 * @method bindUserWechatByCodeByParams(array $params)
 * @method getMappingPicByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取七牛云上传token
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取hostInitPrefix
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHostInitPrefix () {
        return self::getClass()->getHostInitPrefix();
    }

    /**
     * 获取机构
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrgInfo () {
        return self::getClass()->getOrgInfo();
    }

    /**
     * 事件记录
     *
     * @param  int $eventId 事件id [ require true ]
     * @param  array $data 记录数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function eventLog (int $eventId, array $data = []) {
        return self::getClass()->eventLog([
            "eventId" => $eventId,
            "data" => $data,
        ]);
    }

    /**
     * 获取反馈标签s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFeedbackLabels () {
        return self::getClass()->getFeedbackLabels();
    }

    /**
     * 获取im票据
     *
     * @param  int $id 用户或者StaffId [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getImSign (int $id, string $type) {
        return self::getClass()->getImSign([
            "id" => $id,
            "type" => $type,
        ]);
    }

    /**
     * 根据code绑定用户
     *
     * @param  int $userId code [ require true ]
     * @param  string $code 小程序code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindUserWechatByCode (int $userId, string $code) {
        return self::getClass()->bindUserWechatByCode([
            "userId" => $userId,
            "code" => $code,
        ]);
    }

    /**
     * 获取贴图
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMappingPic (int $productId) {
        return self::getClass()->getMappingPic([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}