<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method saveWatchTypeByParams(array $params)
 * @method getWatchRecordsByPhoneWithCodeByParams(array $params)
 * @method saveTakeTypeByParams(array $params)
 * @method getTakeTypeByParams(array $params)
 * @method banReplyByParams(array $params)
 * @method replyByParams(array $params)
 * @method getRecordWatcherWorkStateByParams(array $params)
 */
class WatchRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据看片[序列号/id]获取看片单信息
     *
     * @support  int $id 看片记录id [Original type uint] 
     * @support  string $recordNo 看片序列号 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 保存看片方式
     *
     * @param  int $id 看片记录id [Original type uint] [ require true ]
     * @param  string $watchType 看片方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveWatchType (int $id, string $watchType) {
        return self::getClass()->saveWatchType([
            "id" => $id,
            "watchType" => $watchType,
        ]);
    }

    /**
     * 根据手机号＋验证码获取看片单列表
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @param  string $outsideNo 外部单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWatchRecordsByPhoneWithCode (string $phone = NULL, string $code = NULL, string $outsideNo = NULL) {
        return self::getClass()->getWatchRecordsByPhoneWithCode([
            "phone" => $phone,
            "code" => $code,
            "outsideNo" => $outsideNo,
        ]);
    }

    /**
     * 保存取片方式
     *
     * @param  int $id 看片记录id [Original type uint] [ require true ]
     * @support  string $takeType 取片方式 [ require true ]
     * @support  array $postInfo 邮寄地址 
     * @support  int $postInfo.province 省份 [Original type uint] 
     * @support  int $postInfo.city 城市 [Original type uint] 
     * @support  int $postInfo.area 地区 [Original type uint] 
     * @support  string $postInfo.detail 详细 
     * @support  string $postInfo.name 顾客名 
     * @support  string $postInfo.phone 电话 
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveTakeType (int $id) {
        return self::getClass()->saveTakeType([
            "id" => $id,
        ]);
    }

    /**
     * 获取取片方式
     *
     * @param  int $id 看片记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTakeType (int $id) {
        return self::getClass()->getTakeType([
            "id" => $id,
        ]);
    }

    /**
     * 看片单禁止自动回复(不再提示)
     *
     * @param  int $id 看片记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function banReply (int $id) {
        return self::getClass()->banReply([
            "id" => $id,
        ]);
    }

    /**
     * 看片单自动回复
     *
     * @param  int $id 看片记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reply (int $id) {
        return self::getClass()->reply([
            "id" => $id,
        ]);
    }

    /**
     * 获取看片单对应看片师工作状态
     *
     * @param  int $id 看片记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRecordWatcherWorkState (int $id) {
        return self::getClass()->getRecordWatcherWorkState([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'SmallProgram\My\WatchRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'SmallProgram\My\WatchRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}