<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initRandomSequenceByParams(array $params)
 * @method getQByParams(array $params)
 * @method getQByStaffByParams(array $params)
 * @method getSByParams(array $params)
 * @method rQByParams(array $params)
 * @method flushAllByParams(array $params)
 * @method takeWatchingRecordByParams(array $params)
 * @method editWatchingRecordByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成当日日随机码
     *
     * @throws  \Exception
     * @return  array
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 获取当前队列信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getQ () {
        return self::getClass()->getQ();
    }

    /**
     * 获取当前队列信息
     *
     * @param  int $id 看片师id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQByStaff (int $id) {
        return self::getClass()->getQByStaff([
            "id" => $id,
        ]);
    }

    /**
     * 获取伙伴信息
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getS (int $id) {
        return self::getClass()->getS([
            "id" => $id,
        ]);
    }

    /**
     * 重推队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rQ () {
        return self::getClass()->rQ();
    }

    /**
     * 清空redis
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function flushAll () {
        return self::getClass()->flushAll();
    }

    /**
     * test-指派
     *
     * @param  int $watcherId watcherId [Original type uint] [ require true ]
     * @param  int $recordId recordId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeWatchingRecord (int $watcherId, int $recordId) {
        return self::getClass()->takeWatchingRecord([
            "watcherId" => $watcherId,
            "recordId" => $recordId,
        ]);
    }

    /**
     * test-指派
     *
     * @param  int $watcherId watcherId [Original type uint] [ require true ]
     * @param  int $recordId recordId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editWatchingRecord (int $watcherId, int $recordId) {
        return self::getClass()->editWatchingRecord([
            "watcherId" => $watcherId,
            "recordId" => $recordId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}